import UIKit

class ViewController: UIViewController {
    // Declare variables:
    var ble : bleModel!
    var bleStatusDictionary : [String: String] = ["Status": "---"]
    
    // Do when the view is loaded:
    override func viewDidLoad() {
        ble = bleModel()
        NotificationCenter.default.addObserver(self, selector: #selector(updateBleStatus(_:)), name: Notification.Name("updateBleStatus"), object: nil)
        super.viewDidLoad()
    }
    
    // Update the status text:
    @objc func updateBleStatus(_ notification: Notification){
        bleStatusDictionary = notification.userInfo as? [String: String] ?? ["Status": "---"]
        bleStatus.text = bleStatusDictionary["Status"]
        if bleStatus.text == "Status: Connected!"{
            connectVar.backgroundColor = #colorLiteral(red: 0, green: 0.9768045545, blue: 0, alpha: 1)
            disconnectVar.backgroundColor = #colorLiteral(red: 0.7540688515, green: 0.7540867925, blue: 0.7540771365, alpha: 1)
        }
        if bleStatus.text == "Status: Disconnected!"{
            connectVar.backgroundColor = #colorLiteral(red: 0.7540688515, green: 0.7540867925, blue: 0.7540771365, alpha: 1)
            disconnectVar.backgroundColor = #colorLiteral(red: 1, green: 0.1491314173, blue: 0, alpha: 1)
        }
    }
    
    // Toggle the color of the pixle when pressed:
    func toggleColor(pixel: UIButton){
        if pixel.backgroundColor == #colorLiteral(red: 0.921431005, green: 0.9214526415, blue: 0.9214410186, alpha: 1) {pixel.backgroundColor = #colorLiteral(red: 0, green: 0.9768045545, blue: 0, alpha: 1)}
        else {pixel.backgroundColor = #colorLiteral(red: 0.921431005, green: 0.9214526415, blue: 0.9214410186, alpha: 1)}
    }
    
    // Text fields:
    @IBOutlet weak var serviceUUID: UITextField!
    @IBOutlet weak var characteristicUUID: UITextField!
    @IBOutlet weak var bleStatus: UILabel!
    
    // Connect and disconnect buttons:
    @IBAction func connect(_ sender: UIButton) {
        ble.updateUUID(serviceUUID: serviceUUID.text!, characteristicUUID: characteristicUUID.text!)
        ble.connectToDevice()
        serviceUUID.resignFirstResponder()
        characteristicUUID.resignFirstResponder()
    }
    @IBOutlet weak var connectVar: UIButton!
    @IBAction func disconnect(_ sender: UIButton) {
        ble.disconnectDevice()
    }
    @IBOutlet weak var disconnectVar: UIButton!
    
    // Slider:
    @IBAction func slider(_ sender: UISlider) {
        ble.updateData(index: 0, value: sender.value)
        ble.writeData()
    }
    
    // 6x6 array:
    @IBAction func ArrayA1(_ sender: UIButton) {
        ble.togglePixel(index: 0)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayB1(_ sender: UIButton) {
        ble.togglePixel(index: 1)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayC1(_ sender: UIButton) {
        ble.togglePixel(index: 2)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayD1(_ sender: UIButton) {
        ble.togglePixel(index: 3)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayE1(_ sender: UIButton) {
        ble.togglePixel(index: 4)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayF1(_ sender: UIButton) {
        ble.togglePixel(index: 5)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayA2(_ sender: UIButton) {
        ble.togglePixel(index: 6)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayB2(_ sender: UIButton) {
        ble.togglePixel(index: 7)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayC2(_ sender: UIButton) {
        ble.togglePixel(index: 8)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayD2(_ sender: UIButton) {
        ble.togglePixel(index: 9)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayE2(_ sender: UIButton) {
        ble.togglePixel(index: 10)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayF2(_ sender: UIButton) {
        ble.togglePixel(index: 11)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayA3(_ sender: UIButton) {
        ble.togglePixel(index: 12)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayB3(_ sender: UIButton) {
        ble.togglePixel(index: 13)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayC3(_ sender: UIButton) {
        ble.togglePixel(index: 14)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayD3(_ sender: UIButton) {
        ble.togglePixel(index: 15)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayE3(_ sender: UIButton) {
        ble.togglePixel(index: 16)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayF3(_ sender: UIButton) {
        ble.togglePixel(index: 17)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayA4(_ sender: UIButton) {
        ble.togglePixel(index: 18)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayB4(_ sender: UIButton) {
        ble.togglePixel(index: 19)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayC4(_ sender: UIButton) {
        ble.togglePixel(index: 20)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayD4(_ sender: UIButton) {
        ble.togglePixel(index: 21)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayE4(_ sender: UIButton) {
        ble.togglePixel(index: 22)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayF4(_ sender: UIButton) {
        ble.togglePixel(index: 23)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayA5(_ sender: UIButton) {
        ble.togglePixel(index: 24)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayB5(_ sender: UIButton) {
        ble.togglePixel(index: 25)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayC5(_ sender: UIButton) {
        ble.togglePixel(index: 26)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayD5(_ sender: UIButton) {
        ble.togglePixel(index: 27)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayE5(_ sender: UIButton) {
        ble.togglePixel(index: 28)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayF5(_ sender: UIButton) {
        ble.togglePixel(index: 29)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayA6(_ sender: UIButton) {
        ble.togglePixel(index: 30)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayB6(_ sender: UIButton) {
        ble.togglePixel(index: 31)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayC6(_ sender: UIButton) {
        ble.togglePixel(index: 32)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayD6(_ sender: UIButton) {
        ble.togglePixel(index: 33)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayE6(_ sender: UIButton) {
        ble.togglePixel(index: 34)
        ble.writeData()
        toggleColor(pixel: sender)
    }
    @IBAction func ArrayF6(_ sender: UIButton) {
        ble.togglePixel(index: 35)
        ble.writeData()
        toggleColor(pixel: sender)
    }
}
